require 'net/http'
require 'uri'
require 'json'

def get_location(city)
  url = URI("https://nominatim.openstreetmap.org/search?format=json&q=#{city}&limit=1")

  response = Net::HTTP.get(URI(url))
  JSON.parse(response)[0]
end

def get_weather(latitude, longitude)
  url = URI("https://api.open-meteo.com/v1/forecast?latitude=#{latitude}&longitude=#{longitude}&current=temperature_2m&hourly=temperature_2m")

  response = Net::HTTP.get(URI(url))
  JSON.parse(response)["current"]["temperature_2m"]
end

location = get_location(ARGV[0])
latitude = location['lat'].to_s
longitude = location['lon'].to_s
puts get_weather(latitude,longitude)